/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.parts;

import de.willuhn.jameica.bookmark.Bookmark;
import de.willuhn.jameica.bookmark.BookmarkService;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.internal.action.BookmarkAdd;
import de.willuhn.jameica.gui.internal.action.BookmarkDelete;
import de.willuhn.jameica.gui.parts.PanelButton;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;

public class PanelButtonBookmark
extends PanelButton {
    private MessageConsumer mcCreate = new MyCreateMessageConsumer();
    private MessageConsumer mcDelete = new MyDeleteMessageConsumer();
    private static final String ICON_STARRED = "starred.png";
    private static final String ICON_NONSTARRED = "non-starred.png";
    private static final String TEXT_CREATE = Application.getI18n().tr("Lesezeichen erstellen");
    private static final String TEXT_DELETE = Application.getI18n().tr("(Zum L\u00f6schen erneut klicken)");

    public PanelButtonBookmark() {
        super(ICON_NONSTARRED, new BookmarkAdd(), TEXT_CREATE);
        BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        BookmarkService bs = service.get(BookmarkService.class);
        try {
            Bookmark b = bs.find();
            if (b != null) {
                this.setIcon(ICON_STARRED);
                this.setAction(new BookmarkDelete(b));
                String comment = StringUtils.trimToNull((String)b.getComment());
                Object tooltip = TEXT_DELETE;
                if (comment != null) {
                    tooltip = comment + "\n" + (String)tooltip;
                }
                if (comment == null) {
                    comment = Application.getI18n().tr("Lesezeichen");
                }
                Application.getMessagingFactory().sendMessage(new StatusBarMessage(comment, 2));
                this.setTooltip((String)tooltip);
            }
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(ae.getMessage(), 1));
        }
        Application.getMessagingFactory().getMessagingQueue("jameica.bookmark.created").registerMessageConsumer(this.mcCreate);
        Application.getMessagingFactory().getMessagingQueue("jameica.bookmark.deleted").registerMessageConsumer(this.mcDelete);
    }

    @Override
    protected Control getControl() {
        Control c = super.getControl();
        c.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Application.getMessagingFactory().getMessagingQueue("jameica.bookmark.created").unRegisterMessageConsumer(PanelButtonBookmark.this.mcCreate);
                Application.getMessagingFactory().getMessagingQueue("jameica.bookmark.deleted").unRegisterMessageConsumer(PanelButtonBookmark.this.mcDelete);
            }
        });
        return c;
    }

    @Override
    public boolean isEnabled() {
        return GUI.getCurrentView().canBookmark();
    }

    private class MyCreateMessageConsumer
    implements MessageConsumer {
        private MyCreateMessageConsumer() {
        }

        @Override
        public boolean autoRegister() {
            return false;
        }

        @Override
        public Class[] getExpectedMessageTypes() {
            return new Class[]{QueryMessage.class};
        }

        @Override
        public void handleMessage(Message message) throws Exception {
            QueryMessage msg = (QueryMessage)message;
            final Bookmark bookmark = (Bookmark)msg.getData();
            GUI.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    PanelButtonBookmark.this.setIcon(PanelButtonBookmark.ICON_STARRED);
                    PanelButtonBookmark.this.setTooltip(bookmark.getComment() + "\n" + TEXT_DELETE);
                    PanelButtonBookmark.this.setAction(new BookmarkDelete(bookmark));
                }
            });
        }
    }

    private class MyDeleteMessageConsumer
    implements MessageConsumer {
        private MyDeleteMessageConsumer() {
        }

        @Override
        public boolean autoRegister() {
            return false;
        }

        @Override
        public Class[] getExpectedMessageTypes() {
            return new Class[]{QueryMessage.class};
        }

        @Override
        public void handleMessage(Message message) throws Exception {
            GUI.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    PanelButtonBookmark.this.setIcon(PanelButtonBookmark.ICON_NONSTARRED);
                    PanelButtonBookmark.this.setTooltip(TEXT_CREATE);
                    PanelButtonBookmark.this.setAction(new BookmarkAdd());
                }
            });
        }
    }
}

